//=============================================================================
// Realms TournamentScoreBoard
//=============================================================================
class Realms_Scoreboard extends TournamentScoreBoard;

#exec TEXTURE IMPORT NAME=SBcenter  FILE=Textures\SB_Center_436x512.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBbottomleft  FILE=Textures\SB_BottomLeft.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBbottomright  FILE=Textures\SB_BottomRight.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBtopleft  FILE=Textures\SB_TopLeft.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBtopright  FILE=Textures\SB_TopRight.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBxframe  FILE=Textures\SB_Xframe.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SByframe  FILE=Textures\SB_Yframe.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBbackground  FILE=Textures\SB_Background.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=SBlogo  FILE=Textures\SB_RealmsLogo.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=blackdot  FILE=Textures\blackdot.bmp MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor, GreyColor,LogoColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

var string RealmsVersion;

var int Xpos[80], Ypos[40];
var float Xoffset,Yoffset,AdjustedX,AdjustedY;
var int xx,yy,speed;

var int CR,CG,CB;
var bool bCR,bCG,bCB;

function SetUpSB(canvas Canvas)
{
local float X,Y,Xoffset,Yoffset;


	//Canvas.Style = Style;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;

	//draw top left element
	Canvas.SetPos(0, 0);
	Canvas.DrawTile(Texture'SBtopleft', 32, 32, 0, 0, 32, 32);

	//draw top right element
	Canvas.SetPos(Canvas.ClipX - 32, 0);
	Canvas.DrawTile(Texture'SBtopright', 32, 32, 0, 0, 32, 32);

	//draw bottom left element
	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'SBbottomleft', 32, 32, 0, 0, 32, 32);

	//draw bottom right element
	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'SBbottomright', 32, 32, 0, 0, 32, 32);

	//draw X and Y lines between elements
	X = Canvas.ClipX - 64;
	Y = Canvas.ClipY - 64;
	Canvas.SetPos(32, 0);
	Canvas.DrawTile(Texture'SBxframe', X, 32, 0, 0, 32, 32);
	Canvas.SetPos(32, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'SBxframe', X, 32, 0, 0, 32, 32);
	Canvas.SetPos(0, 32);
	Canvas.DrawTile(Texture'SByframe', 32, Y, 0, 0, 32, 32);
	Canvas.SetPos(Canvas.ClipX - 32, 32);
	Canvas.DrawTile(Texture'SByframe', 32, Y, 0, 0, 32, 32);

	//draw brick background
	Canvas.SetPos(32, 32);
	Canvas.DrawTile(Texture'SBbackground', X, Y, 0, 0, 1024, 640);

	//check if screenresolution is big eneough for enter creature to be drawn
	if ( Canvas.ClipY >= 600 )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 218, Canvas.ClipY * 0.5 - 256);
		Canvas.DrawTile(Texture'SBcenter', 436, 512, 0, 0, 436, 512);
		}

	//draw SB logo
	Xoffset = Canvas.ClipX * 0.5 - 250;
	Yoffset = 34;
	Canvas.DrawColor = LogoColor;
	Canvas.SetPos(Xoffset + AdjustedX, Yoffset + AdjustedY);
	Canvas.DrawTile(Texture'SBlogo', 256, 64, 0, 0, 256, 64);

	

	Canvas.Style = ERenderStyle.STY_Normal;
}

simulated function Tick(float DT) 
{
local byte RC,GC,BC;
	
Super.Tick(DT);
	
//Animate the logo position
if ( speed >= 4 )
	{
	xx++;
	yy++;
	if ( xx > 79 )
		{
		xx = 0;
		}
	if ( yy > 28 )
		{
		yy = 0;
		}	
	AdjustedX = Xpos[xx];
	AdjustedY = Ypos[yy];
	speed = 0;
	}
speed++;

//cycle the logo drawcolor
if ( !bCR )
	{
	CR += 2;
	if ( CR > 255 )
		{
		CR = 255;
		bCR = True;
		}
	}
else
	{
	CR -= 2;
	if ( CR < 0 )
		{
		CR = 0;
		bCR = False;
		}
	}
if ( !bCG )
	{
	CG += 4;
	if ( CG > 255 )
		{
		CG = 255;
		bCG = True;
		}
	}
else
	{
	CG -= 4;
	if ( CG < 0 )
		{
		CG = 0;
		bCG = False;
		}
	}
if ( !bCB )
	{
	CB += 6;
	if ( CB > 255 )
		{
		CB = 255;
		bCB = True;
		}
	}
else
	{
	CB -= 6;
	if ( CB < 0 )
		{
		CB = 0;
		bCB = False;
		}
	}
RC = CR;
GC = CG;
BC = CB;
LogoColor.R = RC;
LogoColor.G = GC;
LogoColor.B = BC;
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	SetUpSB(Canvas);

	//Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 16;	//58.0/768.0 * Canvas.ClipY
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		//Canvas.DrawColor = WhiteColor;
		//Canvas.SetPos(0, ScoreStart);
		//Canvas.DrawText(GRI.GameName$" "@RealmsVersion$" by TheDane");
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart + YL * 1.5);
		Canvas.DrawText("The realm has been completed!", True);
	}
/*
	else
	{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
	}
*/
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName$" "@RealmsVersion$" by TheDane");
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = BlueColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 32);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - 16);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
	local float Offset, XL, YL;

	Offset = Canvas.CurY;
	Canvas.DrawColor = WhiteColor;

	Canvas.StrLen(PlayerString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*2 - XL/2, Offset);
	Canvas.DrawText(PlayerString);

	Canvas.StrLen(FragsString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*5 - XL/2, Offset);
	Canvas.DrawText(FragsString);

	Canvas.StrLen(DeathsString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*6 - XL/2, Offset);
	Canvas.DrawText(DeathsString);
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3, X, Y;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local Realms_Models_MaleKnight MK;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetMediumFont(Canvas.ClipX);

	// Draw Score background
	Canvas.DrawColor = WhiteColor;
	X = Canvas.ClipX * 0.5;
	Canvas.SetPos(X - 256, YOffset);
	Canvas.Style = ERenderStyle.STY_Translucent;
	//Canvas.DrawTile(Texture'UnrealShare.Effect55.FireEffect55', 512, 32, 0, 0, 256, 64);
	Canvas.DrawTile(Texture'UnrealShare.CFLAM.Cflame', 512, 32, 0, 0, 512, 64);
	//Canvas.DrawTile(Texture'UnrealShare.Effect3.FireEffect3', 512, 32, 0, 0, 64, 64);
	//Canvas.DrawTile(Texture'UnrealShare.Effect3a.FireEffect3a', 512, 32, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(X - 257, YOffset - 1);
	Canvas.DrawTile(Texture'blackdot', 514, 1, 0, 0, 2, 2);
	Canvas.SetPos(X - 257, YOffset + 31);
	Canvas.DrawTile(Texture'blackdot', 514, 1, 0, 0, 2, 2);
	Canvas.SetPos(X - 257, YOffset );
	Canvas.DrawTile(Texture'blackdot', 1, 31, 0, 0, 2, 2);
	Canvas.SetPos(X + 256, YOffset );
	Canvas.DrawTile(Texture'blackdot', 1, 31, 0, 0, 2, 2);

	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GreenColor;
	else 
		Canvas.DrawColor = CyanColor;

	Canvas.SetPos(X - 254, YOffset + 4);
	Canvas.DrawText(PRI.PlayerName, False);

	// Draw Score
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen( int(PRI.Score), XL2, YL );
	Canvas.SetPos( X + 115, YOffset + 16);
	Canvas.DrawText("Score:"@int(PRI.Score), false );

	// Draw Deaths
	Canvas.StrLen( int(PRI.Deaths), XL2, YL );
	Canvas.SetPos( X + 30, YOffset + 16);
	Canvas.DrawText("Level:"@int(PRI.Deaths), false );

	// Draw Gold
	if ( PlayerPawn(Owner).IsA('Realms_Models_MaleKnight'))
		{
		Canvas.StrLen( MK.Gold, XL2, YL );
		Canvas.SetPos( X + 30, YOffset );
		Canvas.DrawText("Gold: "@MK.Gold, false );
		}
/*
	if ( (Canvas.ClipX > 512) && (Level.NetMode != NM_Standalone) )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset + 0.5 * YL );
		Canvas.DrawText( FPHString$": "@int(60 * PRI.Score/Time), false );

		XL3 = FMax(XL3, XL2);
		// Draw Ping
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL + XL3 + 16, YOffset );
		Canvas.DrawText( PingString$":"@PRI.Ping, false );
	}
*/
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	YOffset = 96; // set Y location of where to begin drawing Playernames and stats

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	//DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
/*	YStart = Canvas.CurY;
	YOffset = YStart;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);
*/
	Canvas.SetPos(0, 0);
	for ( I=0; I<PlayerCount; I++ )
	{
		YOffset += 32;
		DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     RealmsVersion="beta 1"
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The Realm has been completed."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Score"
     DeathsString="Level"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     GreyColor=(R=50,G=50,B=50)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     LogoColor=(R=0,G=0,B=0)
Xpos(0)=0
Xpos(1)=0
Xpos(2)=0
Xpos(3)=1
Xpos(4)=1
Xpos(5)=2
Xpos(6)=3
Xpos(7)=5
Xpos(8)=8
Xpos(9)=12
Xpos(10)=17
Xpos(11)=23
Xpos(12)=30
Xpos(13)=38
Xpos(14)=47
Xpos(15)=57
Xpos(16)=68
Xpos(17)=78
Xpos(18)=88
Xpos(19)=98
Xpos(20)=108
Xpos(21)=118
Xpos(22)=128
Xpos(23)=138
Xpos(24)=148
Xpos(25)=158
Xpos(26)=168
Xpos(27)=178
Xpos(28)=188
Xpos(29)=198
Xpos(30)=207
Xpos(31)=215
Xpos(32)=222
Xpos(33)=228
Xpos(34)=233
Xpos(35)=237
Xpos(36)=240
Xpos(37)=242
Xpos(38)=243
Xpos(39)=243
Xpos(40)=244
Xpos(41)=244
Xpos(42)=244
Xpos(43)=243
Xpos(44)=243
Xpos(45)=242
Xpos(46)=240
Xpos(47)=237
Xpos(48)=233
Xpos(49)=228
Xpos(50)=222
Xpos(51)=215
Xpos(52)=207
Xpos(53)=198
Xpos(54)=188
Xpos(55)=178
Xpos(56)=168
Xpos(57)=158
Xpos(58)=148
Xpos(59)=138
Xpos(60)=128
Xpos(61)=118
Xpos(62)=108
Xpos(63)=98
Xpos(64)=88
Xpos(65)=78
Xpos(66)=68
Xpos(67)=57
Xpos(68)=47
Xpos(69)=38
Xpos(70)=30
Xpos(71)=23
Xpos(72)=17
Xpos(73)=12
Xpos(74)=8
Xpos(75)=5
Xpos(76)=3
Xpos(77)=2
Xpos(78)=1
Xpos(79)=1
Ypos(0)=0
Ypos(1)=0
Ypos(2)=1
Ypos(3)=2
Ypos(4)=4
Ypos(5)=7
Ypos(6)=11
Ypos(7)=16
Ypos(8)=22
Ypos(9)=27
Ypos(10)=31
Ypos(11)=34
Ypos(12)=36
Ypos(13)=37
Ypos(14)=38
Ypos(15)=38
Ypos(16)=37
Ypos(17)=36
Ypos(18)=34
Ypos(19)=31
Ypos(20)=27
Ypos(21)=22
Ypos(22)=16
Ypos(23)=11
Ypos(24)=7
Ypos(25)=4
Ypos(26)=2
Ypos(27)=1
Ypos(28)=
Ypos(29)=
Ypos(30)=
Ypos(31)=
Ypos(32)=
Ypos(33)=
Ypos(34)=
Ypos(35)=
Ypos(36)=
Ypos(37)=
Ypos(38)=
Ypos(39)=
}



















































